<?php

namespace LWVendor;

/**
 * XHTML 1.1 Target Module, defines target attribute in link elements.
 */
class HTMLPurifier_HTMLModule_Target extends HTMLPurifier_HTMLModule
{
    /**
     * @type string
     */
    public $name = 'Target';
    /**
     * @param HTMLPurifier_Config $config
     */
    public function setup($config)
    {
        $elements = array('a');
        foreach ($elements as $name) {
            $e = $this->addBlankElement($name);
            $e->attr = array('target' => new HTMLPurifier_AttrDef_HTML_FrameTarget());
        }
    }
}
/**
 * XHTML 1.1 Target Module, defines target attribute in link elements.
 */
\class_alias('LWVendor\\HTMLPurifier_HTMLModule_Target', 'HTMLPurifier_HTMLModule_Target', \false);
// vim: et sw=4 sts=4
